/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.strategy;

import cpl.clnat.calculus.CLNRuleIdentifiers;
import cpl.clnat.calculus.Down_Elim_AND_0;
import cpl.clnat.calculus.Down_Elim_AND_1;
import cpl.clnat.calculus.Down_Elim_IMPLIES;
import cpl.clnat.calculus.ID_ClashDetectionRule;
import cpl.clnat.calculus._CLNAbstractRule;
import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.sequent._CLNSequent;
import java.util.LinkedList;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

public class DownExpansionPhase {
    private CLNatFormulaFactory formulaFactory;
    private BitSetOfFormulas resourceSet;
    private LinkedList<RuleInstance> rulesToApply;

    public DownExpansionPhase(_CLNSequent goal) {
        this.formulaFactory = goal.getFormulaFactory();
        this.rulesToApply = new LinkedList();
        Formula headFormula = goal.getHeadFormula();
        Formula toExtract = goal.getRight();
        _CLNSequent axiomSeq = goal.clone();
        axiomSeq.markDown();
        axiomSeq.setHeadFormula(headFormula);
        axiomSeq.addRight(headFormula);
        this.rulesToApply.add(new RuleInstance(CLNRuleIdentifiers.ID_CLASH_DETECTION, headFormula));
        this.resourceSet = new BitSetOfFormulas(this.formulaFactory);
        this.buildDownRules(headFormula, toExtract);
    }

    private void buildDownRules(Formula headFormula, Formula toExtract) {
        if (headFormula.equals(toExtract)) {
            return;
        }
        switch (headFormula.mainConnective()) {
            case AND: {
                if (this.formulaFactory.positiveSubFormulasOf(headFormula.immediateSubformulas()[0]).contains(toExtract)) {
                    this.resourceSet.add(headFormula.immediateSubformulas()[1]);
                    this.rulesToApply.addFirst(new RuleInstance(CLNRuleIdentifiers.ELIM_AND_DOWN_0, headFormula));
                    this.buildDownRules(headFormula.immediateSubformulas()[0], toExtract);
                } else {
                    this.resourceSet.add(headFormula.immediateSubformulas()[0]);
                    this.rulesToApply.addFirst(new RuleInstance(CLNRuleIdentifiers.ELIM_AND_DOWN_1, headFormula));
                    this.buildDownRules(headFormula.immediateSubformulas()[1], toExtract);
                }
                return;
            }
            case IMPLIES: {
                this.rulesToApply.addFirst(new RuleInstance(CLNRuleIdentifiers.ELIM_IMPLIES_DOWN, headFormula));
                this.buildDownRules(headFormula.immediateSubformulas()[1], toExtract);
                return;
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    public BitSetOfFormulas getClosingMatchResoucerceSet() {
        return this.resourceSet;
    }

    public _CLNAbstractRule getNextRuleToApply(_CLNSequent goal) {
        RuleInstance ruleInstanceToApply = this.rulesToApply.removeFirst();
        switch (ruleInstanceToApply.ruleId) {
            case ID_CLASH_DETECTION: {
                if (!goal.isIdentityAxiom()) {
                    throw new ImplementationError(ImplementationError.SOMETHING_WENT_WRONG);
                }
                return new ID_ClashDetectionRule(goal);
            }
            case ELIM_AND_DOWN_0: {
                if (ruleInstanceToApply.mainFormula.mainConnective() != PropositionalConnective.AND || !ruleInstanceToApply.mainFormula.immediateSubformulas()[0].equals(goal.getRight()) || !goal.getResourceSet().contains(ruleInstanceToApply.mainFormula.immediateSubformulas()[1])) {
                    throw new ImplementationError(ImplementationError.SOMETHING_WENT_WRONG);
                }
                return new Down_Elim_AND_0(goal, ruleInstanceToApply.mainFormula);
            }
            case ELIM_AND_DOWN_1: {
                if (ruleInstanceToApply.mainFormula.mainConnective() != PropositionalConnective.AND || !ruleInstanceToApply.mainFormula.immediateSubformulas()[1].equals(goal.getRight()) || !goal.getResourceSet().contains(ruleInstanceToApply.mainFormula.immediateSubformulas()[0])) {
                    throw new ImplementationError(ImplementationError.SOMETHING_WENT_WRONG);
                }
                return new Down_Elim_AND_1(goal, ruleInstanceToApply.mainFormula);
            }
            case ELIM_IMPLIES_DOWN: {
                if (ruleInstanceToApply.mainFormula.mainConnective() != PropositionalConnective.IMPLIES || !ruleInstanceToApply.mainFormula.immediateSubformulas()[1].equals(goal.getRight())) {
                    throw new ImplementationError(ImplementationError.SOMETHING_WENT_WRONG);
                }
                return new Down_Elim_IMPLIES(goal, ruleInstanceToApply.mainFormula);
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    private static class RuleInstance {
        CLNRuleIdentifiers ruleId;
        Formula mainFormula;

        public RuleInstance(CLNRuleIdentifiers ruleId, Formula mainFormula) {
            this.ruleId = ruleId;
            this.mainFormula = mainFormula;
        }
    }
}

