/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.sequent;

import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.sequent._CLNSequent;
import java.util.Collection;
import java.util.HashMap;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaProposition;

public class PositiveSubformulas {
    public static BitSetOfFormulas elegibleHeadFormulas(_CLNSequent goal, FormulaProposition wff) {
        CLNatFormulaFactory formulaFactory = goal.getFormulaFactory();
        BitSetOfFormulas result = new BitSetOfFormulas(formulaFactory);
        for (Formula assumption : goal.leftSide()) {
            if (!formulaFactory.positiveSubFormulasOf(assumption).contains(wff)) continue;
            result.add(assumption);
        }
        return result.isEmpty() ? null : result;
    }

    public static BitSetOfFormulas elegibleHeadFormulasWithDisjunctivePositiveSub(_CLNSequent goal) {
        CLNatFormulaFactory formulaFactory = goal.getFormulaFactory();
        BitSetOfFormulas result = new BitSetOfFormulas(formulaFactory);
        for (Formula assumption : goal.leftSide()) {
            if (formulaFactory.positiveSubFormulasOfWithType(assumption, FormulaType.OR_WFF).isEmpty()) continue;
            result.add(assumption);
        }
        return result.isEmpty() ? null : result;
    }

    public static HashMap<FormulaProposition, BitSetOfFormulas> elegibleHeadFormulasContainingRestartVariable(_CLNSequent goal) {
        CLNatFormulaFactory formulaFactory = goal.getFormulaFactory();
        BitSetOfFormulas restartSet = goal.getRestartSet();
        Collection<Formula> propInRestartSet = restartSet.getAllFormulas(FormulaType.ATOMIC_WFF);
        if (propInRestartSet == null) {
            return null;
        }
        HashMap<FormulaProposition, BitSetOfFormulas> result = new HashMap<FormulaProposition, BitSetOfFormulas>();
        for (Formula p : propInRestartSet) {
            if (p.isFalse()) continue;
            for (Formula assumption : goal.leftSide()) {
                if (!formulaFactory.positiveSubFormulasOf(assumption).contains(p)) continue;
                BitSetOfFormulas bsf = result.get(p);
                if (bsf == null) {
                    bsf = new BitSetOfFormulas(formulaFactory);
                    bsf.add(assumption);
                    result.put((FormulaProposition)p, bsf);
                    continue;
                }
                bsf.add(p);
            }
        }
        return result.size() == 0 ? null : result;
    }
}

