/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.sequent;

import java.io.Serializable;
import java.util.HashMap;
import jtabwb.util.ImplementationError;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.basic.PropositionalConnective;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.FormulaFactory;
import jtabwbx.prop.formula.FormulaProposition;

public class CLNatFormulaFactory
extends FormulaFactory
implements Serializable {
    private HashMap<Integer, BitSetOfFormulas> positiveSubformulas;
    private HashMap<Integer, BitSetOfFormulas> allSubformulas;

    public CLNatFormulaFactory() {
        super("false", "@TRUE");
        super.setTranslateEquivalences(true);
        super.setTranslateNegations(true);
        this.positiveSubformulas = new HashMap();
        this.allSubformulas = new HashMap();
    }

    @Override
    public String getDescription() {
        return "Formula factory for Nbu formulas";
    }

    public BitSetOfFormulas positiveSubFormulasOf(Formula wff) {
        BitSetOfFormulas bsf = this.positiveSubformulas.get(wff.getIndex());
        if (bsf != null) {
            return bsf;
        }
        bsf = new BitSetOfFormulas(this);
        bsf.add(wff);
        if (wff.isAtomic()) {
            return bsf;
        }
        switch (wff.mainConnective()) {
            case AND: {
                bsf.addAll(this.positiveSubFormulasOf(wff.immediateSubformulas()[0]));
                bsf.addAll(this.positiveSubFormulasOf(wff.immediateSubformulas()[1]));
                return bsf;
            }
            case IMPLIES: {
                bsf.addAll(this.positiveSubFormulasOf(wff.immediateSubformulas()[1]));
                return bsf;
            }
        }
        return bsf;
    }

    public BitSetOfFormulas subFormulasOf(Formula wff) {
        BitSetOfFormulas bsf = this.allSubformulas.get(wff.getIndex());
        if (bsf != null) {
            return bsf;
        }
        bsf = new BitSetOfFormulas(this);
        bsf.add(wff);
        if (wff.isAtomic()) {
            return bsf;
        }
        switch (wff.mainConnective()) {
            case AND: 
            case IMPLIES: 
            case OR: 
            case EQ: {
                bsf.addAll(this.subFormulasOf(wff.immediateSubformulas()[0]));
                bsf.addAll(this.subFormulasOf(wff.immediateSubformulas()[1]));
                return bsf;
            }
            case NOT: {
                bsf.addAll(this.subFormulasOf(wff.immediateSubformulas()[0]));
                return bsf;
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }

    public BitSetOfFormulas positiveSubFormulasOfWithType(Formula wff, FormulaType type) {
        BitSetOfFormulas positiveSubformulas = this.positiveSubFormulasOf(wff).clone();
        positiveSubformulas.and(this.getGeneratedFormulasOfType(type));
        return positiveSubformulas;
    }

    public Formula build(Formula wff) {
        if (wff.isAtomic()) {
            return this.buildAtomic(((FormulaProposition)wff).getName());
        }
        Formula[] subwwfs = wff.immediateSubformulas();
        PropositionalConnective connective = wff.mainConnective();
        switch (connective) {
            case NOT: {
                return this.buildCompound(connective, subwwfs[0]);
            }
            case AND: 
            case IMPLIES: 
            case OR: 
            case EQ: {
                return this.buildCompound(connective, subwwfs);
            }
        }
        throw new ImplementationError(ImplementationError.CASE_NOT_IMPLEMENTED);
    }
}

