/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.sequent;

import cpl.clnat.sequent._CLNSequent;
import jtabwbx.prop.formula.FormulaLatexFormatter;

public class CLNSequentLatexFormatter {
    public static final String LATEX_MACROS = "\\usepackage{xifthen}\n\\newcommand{\\up}{\\!\\Uparrow} \n\\newcommand{\\down}{\\!\\downarrow}\n\n\n\\newcommand{\\sequp}[3]{[\n\\ifthenelse{\\isempty{#1}}{\\,}{#1}\\, \\vdash\\, #2 \\up \\, ; \\, \n\\ifthenelse{\\isempty{#3}}{\\,}{#3}]}\n\n\\newcommand{\\seqdown}[5]{[\n\\ifthenelse{\\isempty{#1}}{\\,}{#1}\\, ;\\,#2 \\vdash\\, #3 \\down \\, ; \\,\n\\ifthenelse{\\isempty{#4}}{\\,}{#4}\\,;\\,\n\\ifthenelse{\\isempty{#5}}{\\,}{#5}]}\n\n";
    static final String UP_SEQ_FORMAT = "\\sequp{%s}{%s}{%s}";
    static final String DOWN_SEQ_FORMAT = "\\seqdown{%s}{%s}{%s}{%s}{%s}";
    private FormulaLatexFormatter formulaFormatter;

    public CLNSequentLatexFormatter() {
        this.formulaFormatter = new FormulaLatexFormatter();
    }

    public CLNSequentLatexFormatter(FormulaLatexFormatter formulaFormatter) {
        this.formulaFormatter = formulaFormatter;
    }

    public String toLatex(_CLNSequent seq) {
        String context = this.formulaFormatter.toLatex(seq.getAllLeftFormulas(), ", ");
        String rightFormula = this.formulaFormatter.toLatex(seq.getRight());
        String restart = this.formulaFormatter.toLatex(seq.getRestartSet().getAllFormulas(), ", ");
        if (seq.isUpSequent()) {
            return String.format(UP_SEQ_FORMAT, context, rightFormula, restart);
        }
        String headFormula = this.formulaFormatter.toLatex(seq.getHeadFormula());
        String resources = this.formulaFormatter.toLatex(seq.getResourceSet().getAllFormulas(), ", ");
        return String.format(DOWN_SEQ_FORMAT, context, headFormula, rightFormula, restart, resources);
    }
}

