/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.sequent;

import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.sequent._CLNSequent;
import cpl.clnat.strategy.DownExpansionPhase;
import java.util.Collection;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.formula.SingleSuccedentSequentOnBSF;

public class CLNSequent
extends SingleSuccedentSequentOnBSF
implements _CLNSequent {
    public static final int DOWN = 0;
    public static final int UP = 1;
    private BitSetOfFormulas restartSet;
    private int upOrDown;
    private BitSetOfFormulas resourceSet;
    private Formula headFormula;
    private DownExpansionPhase downExpansionPhase;

    public CLNSequent(CLNatFormulaFactory factory, int upOrDown) {
        super(factory);
        this.upOrDown = upOrDown;
        this.resourceSet = upOrDown == 1 ? null : new BitSetOfFormulas(factory);
        this.restartSet = new BitSetOfFormulas(factory);
    }

    @Override
    public void addLeft(BitSetOfFormulas set) {
        for (Formula wff : set) {
            this.addLeft(wff);
        }
    }

    @Override
    public boolean addResource(Formula wff) {
        return this.resourceSet.add(wff);
    }

    @Override
    public boolean removeResource(Formula wff) {
        return this.resourceSet.remove(wff);
    }

    @Override
    public BitSetOfFormulas getResourceSet() {
        return this.resourceSet;
    }

    @Override
    public void setResourceSet(BitSetOfFormulas set) {
        this.resourceSet = set;
    }

    @Override
    public boolean addRestart(Formula wff) {
        return this.restartSet.add(wff);
    }

    @Override
    public boolean removeRestart(Formula wff) {
        return this.restartSet.remove(wff);
    }

    @Override
    public BitSetOfFormulas getRestartSet() {
        return this.restartSet;
    }

    @Override
    public void addLeft(Formula wff) {
        super.addLeft(wff);
    }

    @Override
    public CLNSequent clone() {
        CLNSequent cloned = (CLNSequent)super.clone();
        cloned.restartSet = this.restartSet.clone();
        cloned.upOrDown = this.upOrDown;
        if (this.upOrDown == 0) {
            cloned.resourceSet = this.resourceSet == null ? null : this.resourceSet.clone();
            cloned.headFormula = this.headFormula;
            cloned.downExpansionPhase = this.downExpansionPhase;
        } else {
            cloned.resourceSet = null;
            cloned.headFormula = null;
        }
        return cloned;
    }

    @Override
    public CLNatFormulaFactory getFormulaFactory() {
        return (CLNatFormulaFactory)super.getFormulaFactory();
    }

    @Override
    public Formula getHeadFormula() {
        return this.headFormula;
    }

    @Override
    public boolean isIdentityAxiom() {
        return this.headFormula.equals(this.getRight()) && this.upOrDown == 0 && this.resourceSet.isEmpty();
    }

    @Override
    public boolean isUpSequent() {
        return this.upOrDown == 1;
    }

    @Override
    public boolean isDownSequent() {
        return this.upOrDown == 0;
    }

    @Override
    public boolean leftSideIsEmpty() {
        return false;
    }

    @Override
    public void markUp() {
        this.upOrDown = 1;
        this.resourceSet = null;
        this.headFormula = null;
        this.downExpansionPhase = null;
    }

    @Override
    public void markDown() {
        this.upOrDown = 0;
    }

    @Override
    public void setHeadFormula(Formula wff) {
        this.headFormula = wff;
    }

    @Override
    public void setDownExpansionPhase(DownExpansionPhase phase) {
        this.downExpansionPhase = phase;
    }

    @Override
    public DownExpansionPhase getDownExpansionPhase() {
        return this.downExpansionPhase;
    }

    @Override
    public BitSetOfFormulas positiveSubformulasOfLeftHandSide() {
        BitSetOfFormulas posSub = new BitSetOfFormulas(this.getFormulaFactory());
        for (Formula wff : this.leftSide()) {
            posSub.or(((CLNatFormulaFactory)wff.getFactory()).positiveSubFormulasOf(wff));
        }
        return posSub;
    }

    @Override
    public BitSetOfFormulas positiveSubformulasOfLeftHandSide(FormulaType type) {
        BitSetOfFormulas pos = this.positiveSubformulasOfLeftHandSide();
        pos.and(this.getFormulaFactory().getGeneratedFormulasOfType(type));
        return pos;
    }

    @Override
    public String format() {
        return this.toString();
    }

    @Override
    public String toString() {
        String context_str = this.toString(this.getAllLeftFormulas());
        String restart_str = this.toString(this.restartSet.getAllFormulas());
        String right_str = this.getRight().format();
        if (this.upOrDown == 1) {
            return context_str + " ==>[UP]\n" + right_str + " ; " + restart_str;
        }
        String resource_str = this.toString(this.resourceSet.getAllFormulas());
        String head_str = this.headFormula.format();
        return context_str + " ; " + head_str + " ==>[DOWN]\n" + right_str + " ; " + restart_str + " ; " + resource_str;
    }

    private String toString(Collection<Formula> coll) {
        Object result = "";
        if (coll != null) {
            Formula[] left = coll.toArray(new Formula[coll.size()]);
            for (int i = 0; i < left.length; ++i) {
                result = (String)result + left[i].toString() + (i < left.length - 1 ? ", " : "");
            }
        }
        return result;
    }
}

