/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.launcher;

import cpl.clnat.launcher.InitialGoalBuilder;
import cpl.clnat.launcher.SingelExecutionConfigurator;
import cpl.clnat.sequent.CLNSequent;
import cpl.clnat.tp.CLNProver;
import jtabwb.engine.ProofSearchResult;
import jtabwb.launcher.Launcher;
import jtabwb.launcher.ProofSearchData;
import jtabwbx.problems.ILTPProblemReader;
import jtabwbx.problems.JTabWbSimpleProblemReader;
import jtabwbx.problems.PlainProblemReader;
import jtabwbx.prop.basic.FormulaType;
import jtabwbx.prop.formula.BitSetOfFormulas;
import jtabwbx.prop.formula.Formula;

public class Main {
    private static String FORMULA_SYNTAX_DESCRIPTION = "Syntax of formulas\n  atoms: Java identifiers\nlogical: false, & (and), | (or), ~ (not), -> (implies), <=> (iff)\n  notes: (~ A) is translated as (A -> false)\n         (A <=> B) is translated as ((A -> B) & (B -> A))";
    private final Class<CLNProver> NBU_PROVER_CLASS = CLNProver.class;
    private final String NBU_PROVER_NAME = "clnat";
    private Launcher launcher = new Launcher();

    private Main() {
    }

    private void start(String[] args) {
        this.launcher.configLauncherName(this.getClass().getCanonicalName());
        this.launcher.configStandardInputReader(new PlainProblemReader());
        this.launcher.optConfigInputSyntax(FORMULA_SYNTAX_DESCRIPTION);
        this.launcher.configProblemDescriptionReader("iltp", ILTPProblemReader.class);
        this.launcher.configProblemDescriptionReader("plain", PlainProblemReader.class);
        this.launcher.configProblemDescriptionReader("jtw", JTabWbSimpleProblemReader.class, true);
        InitialGoalBuilder nodSetBuiledr = new InitialGoalBuilder();
        this.launcher.configInitialNodeSetBuilder(nodSetBuiledr);
        this.launcher.configTheoremProver("clnat", this.NBU_PROVER_CLASS, true);
        this.launcher.optConfigSingleExecutionConfigurator(new SingelExecutionConfigurator(nodSetBuiledr));
        this.launcher.processCmdLineArguments(args);
        this.launcher.launch();
        ProofSearchData data = this.launcher.getLastProofSearchData();
        if (data.getResult() == ProofSearchResult.FAILURE) {
            CLNProver prover = (CLNProver)data.getProver();
            CLNSequent irr = prover.getIrreducibleSequent();
            BitSetOfFormulas interp = irr.positiveSubformulasOfLeftHandSide(FormulaType.ATOMIC_WFF);
            Object strInterp = "";
            if (!interp.isEmpty()) {
                Formula[] a = interp.toArray();
                for (int i = 0; i < a.length; ++i) {
                    strInterp = (String)strInterp + a[i].format() + (i < a.length - 1 ? ", " : "");
                }
            }
            System.out.println("The goal\n" + data.goal().format() + "\nis unprovable. A countermodel is [" + (String)strInterp + "].");
        }
    }

    public static void main(String[] args) {
        Main main = new Main();
        main.start(args);
    }
}

