/*
 * Decompiled with CFR 0.152.
 */
package cpl.clnat.launcher;

import cpl.clnat.sequent.CLNSequent;
import cpl.clnat.sequent.CLNatFormulaFactory;
import cpl.clnat.sequent._CLNSequent;
import java.util.LinkedList;
import jtabwb.launcher.InitialGoalBuilderException;
import jtabwb.launcher._InitialGoalBuilder;
import jtabwb.util.ImplementationError;
import jtabwbx.problems.ILTPProblem;
import jtabwbx.problems.JTabWbSimpleProblem;
import jtabwbx.problems.ProblemDescription;
import jtabwbx.prop.formula.Formula;
import jtabwbx.prop.parser.FormulaParseException;
import jtabwbx.prop.parser.PropositionalFormulaParser;

public class InitialGoalBuilder
implements _InitialGoalBuilder {
    private CLNatFormulaFactory formulaFactory;

    public void setFormulaFactory(CLNatFormulaFactory formulaFactory) {
        this.formulaFactory = formulaFactory;
    }

    @Override
    public _CLNSequent buildInitialNodeSet(ProblemDescription inputProblem) throws InitialGoalBuilderException {
        if (inputProblem instanceof JTabWbSimpleProblem) {
            JTabWbSimpleProblem pd = (JTabWbSimpleProblem)inputProblem;
            String problem = pd.getConjecture();
            if (pd.getConjecture() == null) {
                throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
            }
            PropositionalFormulaParser parser = new PropositionalFormulaParser();
            Formula wff = null;
            try {
                wff = this.formulaFactory.buildFrom(parser.parse(problem));
            }
            catch (FormulaParseException e) {
                throw new InitialGoalBuilderException(e.getMessage());
            }
            CLNSequent nodeSet = new CLNSequent(this.formulaFactory, 1);
            nodeSet.addRight(wff);
            return nodeSet;
        }
        if (inputProblem instanceof ILTPProblem) {
            ILTPProblem pd = (ILTPProblem)inputProblem;
            String problem = pd.getConjecture();
            if (pd.getConjecture() == null) {
                throw new InitialGoalBuilderException("No problem formula defined in the input problem.");
            }
            PropositionalFormulaParser parser = new PropositionalFormulaParser();
            Formula right = null;
            LinkedList<Formula> axioms = null;
            try {
                right = this.formulaFactory.buildFrom(parser.parse(problem));
                if (pd.getAxioms() != null) {
                    axioms = new LinkedList<Formula>();
                    for (String axiom : pd.getAxioms()) {
                        axioms.add(this.formulaFactory.buildFrom(parser.parse(axiom)));
                    }
                }
            }
            catch (FormulaParseException e) {
                throw new InitialGoalBuilderException(e.getMessage());
            }
            CLNSequent nodeSet = new CLNSequent(this.formulaFactory, 1);
            if (axioms != null) {
                for (Formula wff : axioms) {
                    nodeSet.addLeft(wff);
                }
            }
            nodeSet.addRight(right);
            return nodeSet;
        }
        throw new ImplementationError("Unkonw problem description.");
    }

    public CLNatFormulaFactory getFormulaFactory() {
        return this.formulaFactory;
    }
}

